module.exports = function (bh) {
    bh.match('conditions', function (ctx, json) {
        var data = json.data;

        if (!data) {
            return '';
        }

        var agreement = data.userAgreement;

        ctx
            .js(true)
            .content([
                {
                    elem: 'list',
                    data: data.list
                },
                agreement && [
                    {
                        elem: 'agreement',
                        mix: [
                            { elem: 'ellipsis' },
                            { block: 'html-content' }
                        ],
                        content: agreement
                    },
                    {
                        elem: 'acceptances',
                        labels: data.acceptances
                    }
                ],
                data.buttonText && {
                    elem: 'button',
                    content: {
                        block: 'button2',
                        mods: { theme: 'action', size: 'l', disabled: 'yes' },
                        text: data.buttonText
                    }
                }
            ]);
    });

    bh.match('conditions__list', function (ctx, json) {
        var data = json.data;

        if (!data || !data.items || data.items.length === 0) {
            return '';
        }

        ctx.content([
            data.label && {
                tag: 'h4',
                elem: 'list-label',
                mix: { elem: 'ellipsis' },
                content: data.label
            },
            {
                block: 'rules-list',
                items: data.items
            }
        ]);
    });

    bh.match('conditions__acceptances', function (ctx, json) {
        var labels = json.labels;

        if (!labels) {
            return '';
        }
        ctx.content(labels.map(function (label) {
            return {
                elem: 'acceptance',
                content: {
                    block: 'checkbox',
                    mods: { theme: 'normal', size: 'm', required: 'yes' },
                    text: {
                        elem: 'label',
                        mix: { block: 'html-content' },
                        content: label
                    }
                }
            };
        }));
    });
};
