BEM.DOM.decl('conditions', {
    onSetMod: {
        js: {
            inited: function () {
                this._checkboxes = this.findBlocksInside('checkbox');
                this._button = this.findBlockInside('button2');

                var bPage = this.findBlockOutside('b-page');

                this._identification = bPage.findBlockInside('identification');

                BEM.blocks.checkbox.on(this.domElem, 'change', this._onCheckboxChange, this);

                if (this._button) {
                    this._button.bindTo('pointerclick', this._onButtonClick.bind(this));
                }
            }
        }
    },

    /**
     * При изменении значения чекбокса делаем кнопку активной
     * @private
     */
    _onCheckboxChange: function () {
        if (!this._button) {
            return;
        }

        var activeCheckboxes = this._checkboxes.filter(function (checkbox) {
            return checkbox.isChecked();
        });

        this._button.toggleMod('disabled', '', 'yes', activeCheckboxes.length === this._checkboxes.length);
    },

    /**
     * При клике на кнопку переходим на следующий шаг
     * @private
     */
    _onButtonClick: function () {
        this.setMod('disabled', 'yes');

        if (this._identification) {
            this._identification.trigger('identification-next');
        }
    }
});
