module.exports = function (bh) {
    'use strict';
    bh.match('exam-start__time-limit', function (ctx, json) {
        ctx.content([
            {
                elem: 'time-title',
                content: bh.lib.i18n('common', 'exam.time')
            },
            {
                elem: 'time',
                content: json.timeLimit
            }
        ]);
    });

    bh.match('exam-start__time', function (ctx) {
        ctx.mix({
            block: 'i-font',
            mods: {
                face: 'yandex-sans-text-thin'
            }
        });
    });

    bh.match('exam-start__auth', function (ctx) {
        var authUrl = bh.lib.util.passport.getUrl();

        ctx.content([
            {
                block: 'button2',
                mods: {
                    theme: 'normal',
                    width: 'max',
                    size: 'm',
                    type: 'link'
                },
                url: authUrl,
                text: bh.lib.i18n('common', 'user.enter')
            }
        ]);
    });

    bh.match('modal__terms-additions', function (ctx, json) {
        ctx.content(json.additions.map(function (addition) {
            return {
                elem: 'addition',
                content: [
                    addition.icon && {
                        elem: 'addition-icon',
                        icon: addition.icon
                    },
                    {
                        elem: 'addition-text',
                        mix: { block: 'html-content' },
                        content: addition.text
                    }
                ]
            };
        }));
    });

    bh.match('modal__addition-icon', function (ctx, json) {
        if (json.icon) {
            ctx.tag('img');
            ctx.attr('src', json.icon);
        }
    });

    bh.match('modal__terms-clearly', function (ctx, json) {
        ctx.content({
            block: 'button2',
            mods: {
                theme: 'action',
                type: 'link',
                size: 'm'
            },
            url: json.attemptUrl,
            text: bh.lib.i18n('common', 'exam.clearly')
        });
    });
};
