module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./exam-start-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'enabled' },
                    content: {
                        block: 'exam-start',
                        exam: data.enabled.exam,
                        examAccess: data.enabled.examAccess,
                        isAuthorized: data.enabled.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'frozen' },
                    content: {
                        block: 'exam-start',
                        exam: data.frozen.exam,
                        examAccess: data.frozen.examAccess,
                        isAuthorized: data.frozen.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'disabled' },
                    content: {
                        block: 'exam-start',
                        exam: data.disabled.exam,
                        examAccess: data.disabled.examAccess,
                        isAuthorized: data.disabled.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'continued' },
                    content: {
                        block: 'exam-start',
                        exam: data.continued.exam,
                        examAccess: data.continued.examAccess,
                        isAuthorized: data.continued.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'unauthorized' },
                    content: {
                        block: 'exam-start',
                        exam: data.unauthorized.exam,
                        examAccess: data.unauthorized.examAccess,
                        isAuthorized: data.unauthorized.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'proctoring-without-supporting' },
                    content: {
                        block: 'exam-start',
                        exam: data.proctoringWithoutSupporting.exam,
                        examAccess: data.proctoringWithoutSupporting.examAccess,
                        isAuthorized: data.proctoringWithoutSupporting.isAuthorized,
                        isBrowserSupportProctoring: data.proctoringWithoutSupporting.isBrowserSupportProctoring,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    height: 280,
                    mods: { type: 'pending' },
                    content: {
                        block: 'exam-start',
                        exam: data.pending.exam,
                        examAccess: data.pending.examAccess,
                        isAuthorized: data.pending.isAuthorized,
                        isBrowserSupportProctoring: data.pending.isBrowserSupportProctoring,
                        passportProfile: '#'
                    }
                }
            ]
        };
    });
};
