module.exports = function (bh) {
    'use strict';
    bh.match('head', function (ctx, json) {
        var levels = bh.lib.getHeaderMenu(bh.lib.global.tld) || [];

        ctx
            .mod('opened', 'no')
            .tag('header')
            .content([
                {
                    elem: 'line-wrap',
                    content: [
                        {
                            elem: 'current-line',
                            content: [
                                {
                                    elem: 'logo',
                                    url: json.mordaHost
                                },
                                {
                                    elem: 'menu',
                                    levels: levels
                                },
                                {
                                    elem: 'right-column',
                                    content: [
                                        {
                                            block: 'user',
                                            mods: {
                                                menu: 'multiauth',
                                                expert: 'yes'
                                            },
                                            content: { elem: 'name' }
                                        },
                                        (levels.length > 1) && {
                                            elem: 'menu-button'
                                        }
                                    ]
                                },
                                {
                                    elem: 'paranja'
                                }
                            ]
                        }
                    ]
                }
            ]);
    });

    bh.match('head__menu', function (ctx, json) {
        var content = json.levels.map(function (services, idx) {
            var current = false;
            var links = services.map(function (service) {
                if (service.current) {
                    current = true;
                }
                return {
                    elem: 'link',
                    current: service.current,
                    url: service.url,
                    name: service.name
                };
            });

            return {
                elem: 'menu-level',
                mods: {
                    current: current,
                    pos: json.levels.length - idx - 1
                },
                content: links
            };
        });

        ctx.content(content.reverse());
    });

    bh.match('head__link', function (ctx, json) {
        var url = json.url || '';

        if (json.current) {
            ctx.mod('current', true);
        }

        if (url) {
            ctx.tag('a');
            ctx.attr('href', url);
        } else {
            ctx.tag('span');
        }

        ctx.content(json.name);
    });
};
