/* global BEM */
BEM.DOM.decl('head', {
    onSetMod: {
        js: {
            inited: function () {
                'use strict';
                var paranja = this.paranja = this.elem('paranja');
                if (paranja) {
                    paranja.on('pointerclick', this.closeMenu.bind(this));
                }

                this.bindToWin('scroll', this.closeMenu.bind(this));
                this.bindToWin('keyup', function (e) {
                    if (e.which === 27) {
                        this.closeMenu();
                    }
                }.bind(this));
            }
        }
    },
    closeMenu: function () {
        'use strict';
        this.setMod('opened', 'no');
    }
}, {
    live: function () {
        'use strict';
        this.liveBindTo('menu-button', 'pointerclick', function () {
            this.toggleMod('opened', 'yes', 'no');
        });
    }
});
