module.exports = function (bh) {
    var STEP_COUNT = 5;
    var CAMERA_STEPS = ['face', 'document'];

    /**
     * Рендерит изобаржение с переданными параметрами
     * @param {String} src
     * @param {String} title
     * @returns {{bemjson}}
     */
    function getImage(src, title) {
        return {
            elem: 'image',
            tag: 'img',
            attrs: {
                title: title,
                alt: title,
                src: src
            }
        };
    }

    bh.match('identification', function (ctx, json) {
        var data = json.data;
        var startUrl = json.startUrl;

        if (!data || !startUrl) {
            return '';
        }

        ctx
            .js({
                identificationUrl: json.identificationUrl,
                userProctoringToken: json.userProctoringToken,
                proctoringIframeUrl: json.proctoringIframeUrl,
                proctoringIframeHost: json.proctoringIframeHost,
                openId: json.openId,
                hardwareSteps: data.hardwareCheck.steps
            })
            .content({
                elem: 'wrapper',
                content: [
                    {
                        block: 'conditions',
                        data: data.conditions
                    },
                    {
                        elem: 'step',
                        mods: { disabled: 'yes' },
                        type: 'hardware-check',
                        data: data.hardwareCheck,
                        number: 1
                    },
                    {
                        elem: 'step',
                        mods: { disabled: 'yes' },
                        type: 'camera-check',
                        data: data.cameraCheck,
                        number: 2
                    },
                    {
                        elem: 'step',
                        mods: { disabled: 'yes' },
                        type: 'face',
                        data: data.face,
                        number: 2
                    },
                    {
                        elem: 'step',
                        mods: { disabled: 'yes' },
                        type: 'document',
                        data: data.document,
                        number: 3
                    },
                    {
                        elem: 'step',
                        mods: { disabled: 'yes' },
                        type: 'thanks',
                        data: data.thanks,
                        number: 4
                    },
                    {
                        elem: 'step',
                        mods: { disabled: 'yes' },
                        type: 'screencast',
                        startUrl: startUrl,
                        data: data.screencast,
                        screencastUrl: json.screencastUrl,
                        number: 5
                    },
                    {
                        elem: 'spinner',
                        mods: { disabled: 'yes' },
                        content: {
                            block: 'spin2',
                            mods: { size: 'l' }
                        }
                    },
                    { block: 'webcam' },
                    { block: 'secret-key-input' },
                    { block: 'notifications-list' }
                ]
            });
    });

    bh.match('identification__step', function (ctx, json) {
        var data = json.data;
        var type = json.type;
        var startUrl = json.startUrl;

        if (!data) {
            return '';
        }

        var image = data.image && getImage(data.image, data.title);
        var isCameraStep = CAMERA_STEPS.indexOf(type) > -1;
        var isNextStepActive = type === 'thanks';

        ctx
            .mods({ type: type })
            .content([
                type !== 'screencast' && {
                    elem: 'content',
                    content: [
                        !startUrl && image,
                        data.title && {
                            elem: 'title',
                            title: data.title
                        },
                        data.text && {
                            elem: 'text',
                            text: data.text
                        },
                        data.buttonText && {
                            elem: 'button',
                            buttonText: data.buttonText,
                            isNextStepActive: isNextStepActive,
                            startUrl: startUrl
                        },
                        json.number && {
                            elem: 'step-number',
                            number: json.number
                        }
                    ]
                },
                data.rules && data.rules.length > 0 && {
                    elem: 'rules',
                    content: {
                        block: 'rules-list',
                        items: data.rules
                    }
                },
                startUrl && image,
                type === 'hardware-check' && {
                    elem: 'hardware-check',
                    content: [
                        {
                            block: 'check-hardware',
                            steps: data.steps
                        },
                        {
                            elem: 'recheck-control',
                            mods: {
                                disabled: 'yes'
                            },
                            content: {
                                elem: 'recheck-button',
                                content: {
                                    block: 'button2',
                                    mods: {
                                        theme: 'pseudo',
                                        size: 'm',
                                        type: 'link'
                                    },
                                    text: bh.lib.i18n('common', 'recheck.hardware')
                                }
                            }
                        }
                    ]
                },
                type === 'camera-check' && {
                    elem: 'camera-check',
                    content: [
                        {
                            elem: 'camera-spinner',
                            mods: { disabled: 'yes' },
                            content: {
                                block: 'spin2',
                                mods: { size: 'l' }
                            }
                        },
                        {
                            elem: 'error',
                            mods: { disabled: 'yes' },
                            content: {
                                elem: 'error-text',
                                content: data.cameraCheckError
                            }
                        },
                        {
                            elem: 'recheck-control',
                            mods: {
                                disabled: 'yes'
                            },
                            content: {
                                elem: 'recheck-button',
                                content: {
                                    block: 'button2',
                                    mods: {
                                        theme: 'pseudo',
                                        size: 'm',
                                        type: 'link',
                                        pin: 'circle-circle'
                                    },
                                    text: bh.lib.i18n('common', 'recheck.camera')
                                }
                            }
                        }
                    ]
                },
                isCameraStep && {
                    elem: 'camera-wrapper',
                    content: [
                        {
                            elem: 'camera',
                            content: [
                                {
                                    elem: 'video',
                                    attrs: { id: type + '-camera' }
                                },
                                {
                                    elem: 'cover-border',
                                    mods: { disabled: 'yes' }
                                },
                                {
                                    elem: 'cover',
                                    mods: { disabled: 'yes' }
                                },
                                {
                                    elem: 'snapshot',
                                    tag: 'img'
                                },
                                {
                                    elem: 'error',
                                    mods: { disabled: 'yes' },
                                    mix: {
                                        block: 'html-content'
                                    },
                                    content: {
                                        elem: 'error-text',
                                        content: data.photoErrorText
                                    }
                                }
                            ]
                        },
                        {
                            elem: 'camera-control',
                            content: bh.lib.i18n('common', 'make.photo')
                        }
                    ]
                },
                type === 'document' && {
                    block: 'modal',
                    mix: { block: 'identification', elem: 'document-modal' },
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes',
                        visible: 'no',
                        step: 'document'
                    },
                    content: {
                        elem: 'doc-example',
                        content: {
                            elem: 'modal-content',
                            content: [
                                {
                                    elem: 'modal-title',
                                    content: data.modalTitle
                                },
                                {
                                    elem: 'modal-text',
                                    content: data.modalText
                                },
                                {
                                    elem: 'modal-image',
                                    content: getImage(data.modalImg)
                                }
                            ]
                        }
                    }
                },
                type === 'screencast' && [
                    {
                        elem: 'screencast-wrapper',
                        content: [
                            {
                                elem: 'screencast-header',
                                content: [
                                    data.title && {
                                        elem: 'title',
                                        title: data.title
                                    },
                                    data.text && {
                                        elem: 'text',
                                        text: data.text
                                    },
                                    {
                                        elem: 'acceptances',
                                        labels: data.acceptances
                                    },
                                    data.buttonText && {
                                        elem: 'button',
                                        buttonText: data.buttonText,
                                        isNextStepActive: isNextStepActive,
                                        startUrl: startUrl
                                    },
                                    json.number && {
                                        elem: 'step-number',
                                        number: json.number
                                    }
                                ]
                            },
                            {
                                elem: 'screencast-data',
                                content: [
                                    {
                                        tag: 'iframe',
                                        attrs: {
                                            src: json.screencastUrl,
                                            allowfullscreen: true,
                                            frameborder: 0,
                                            width: 350,
                                            height: 197
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            ]);
    });

    bh.match('identification__step-number', function (ctx, json) {
        ctx.content(bh.lib.i18n('common', 'identification.step', {
            stepCount: STEP_COUNT,
            currentStep: json.number
        }));
    });

    bh.match('identification__button', function (ctx, json) {
        var startUrl = json.startUrl;

        ctx.content({
            block: 'button2',
            mods: {
                theme: 'action',
                size: 'l',
                disabled: !json.isNextStepActive && 'yes',
                type: startUrl && 'link'
            },
            url: startUrl,
            text: json.buttonText
        });
    });

    bh.match('identification__title', function (ctx, json) {
        ctx
            .tag('h2')
            .content(json.title);
    });

    bh.match('identification__text', function (ctx, json) {
        ctx
            .mix({ block: 'html-content' })
            .content(json.text);
    });

    bh.match('identification__acceptances', function (ctx, json) {
        var labels = json.labels;

        if (!labels) {
            return '';
        }
        ctx.content(labels.map(function (label) {
            return {
                elem: 'acceptance',
                content: {
                    block: 'checkbox',
                    mods: { theme: 'normal', size: 'm', required: 'yes' },
                    text: {
                        elem: 'label',
                        mix: { block: 'html-content' },
                        content: label
                    }
                }
            };
        }));
    });
};
