/* global BEM, BH, $ */
BEM.DOM.decl('identification', {
    onSetMod: {
        js: {
            inited: function () {
                this._photos = { face: null, document: null };
                this._step = 0;
                this._stepName = this._stepsNames[0];
                this._photoSpinner = this.findElem('spinner');
                this._cameraSpinner = this.findElem('camera-spinner');
                this._photoSpin2 = this.findBlockInside(this._photoSpinner, 'spin2');
                this._cameraSpin2 = this.findBlockInside(this._cameraSpinner, 'spin2');
                this._sk = this.findBlockInside('secret-key-input').domElem.val();
                this._docExampleModal = this.findBlockInside({ block: 'modal', modName: 'step', modVal: 'document' });
                this._openId = this.params.openId;
                this._hardwareSteps = this.params.hardwareSteps;

                this._findStepsElems();

                this.on('identification-next', this._onNext.bind(this));
            }
        }
    },

    /**
     * Шаги идентификации
     */
    _stepsNames: ['conditions', 'hardware-check', 'camera-check', 'face', 'document', 'thanks', 'screencast'],

    /**
     * Находит и сохраняет элементы для каждого шага
     * @private
     */
    _findStepsElems: function () {
        this._steps = this._stepsNames.reduce(function (steps, stepName) {
            steps[stepName] = {};

            var $step = this.findElem('step', 'type', stepName);
            var $stepButtonWrapper = this.findElem($step, 'button');
            var button = this.findBlockInside($stepButtonWrapper, 'button2');
            var $cover = this.findElem($step, 'cover');
            var $capture = this.findElem($step, 'camera-control');
            var $snapshot = this.findElem($step, 'snapshot');
            var $coverBorder = this.findElem($step, 'cover-border');
            var $error = this.findElem($step, 'error');
            var $recheck = this.findElem($step, 'recheck-control');
            var $documentExample = this.findElem($step, 'document-example');
            var $acceptances = this.findElem($step, 'acceptances');

            if ($step.length) {
                steps[stepName].$step = $step;
            }

            if (button && stepName !== 'camera-check') {
                var handler = stepName === 'document' ? this._identificate : this._onNext;

                steps[stepName].button = button;
                button.bindTo('pointerclick', handler.bind(this));
            }

            if ($cover.length) {
                steps[stepName].$cover = $cover;
            }

            if ($capture.length) {
                steps[stepName].$capture = $capture;
            }

            if ($snapshot.length) {
                steps[stepName].$snapshot = $snapshot;
            }

            if ($coverBorder.length) {
                steps[stepName].$coverBorder = $coverBorder;
            }

            if ($error.length) {
                steps[stepName].$error = $error;
            }

            if ($recheck.length) {
                steps[stepName].$recheck = $recheck;
                steps[stepName].$recheckButton = this.findBlockInside($recheck, 'button2');
            }

            if ($documentExample.length) {
                this.bindTo($documentExample, 'click', this._showDocumentModal.bind(this));
            }

            if ($acceptances.length) {
                steps[stepName].checkboxes = this.findBlocksInside($acceptances, 'checkbox');

                BEM.blocks.checkbox.on(this.domElem, 'change', this._onCheckboxChange, this);
            }

            return steps;
        }.bind(this), {});
    },

    /**
     * При переходе на следующий шаг скрываем текущий, показываем следующий
     * и инициализируем веб-камеру на новое окно
     * @private
     */
    _onNext: function () {
        this._hideCurrentStep();
        this._step += 1;

        if (this._step >= this._stepsNames.length) {
            return;
        }

        this._stepName = this._stepsNames[this._step];
        this._showCurrentStep();

        var cameraSelector = '#' + this._stepName + '-camera';

        if (this._stepName === 'hardware-check') {
            return this._prepareForCheckHardware();
        }

        if (this._stepName === 'camera-check') {
            return this._checkCamera(cameraSelector);
        }

        if (this._stepName === 'face' || this._stepName === 'document') {
            BEM.blocks.webcam.init(cameraSelector, this._onWebcamInit, this);
        }
    },

    /**
     * Проверка оборудования
     * @private
     */
    _prepareForCheckHardware: function () {
        var step = this._steps[this._stepName];

        this.bindTo('supervisor-iframe-ready', function () {
            BEM.blocks.supervisor.create();
        });

        var supervisor = BH.apply({
            block: 'supervisor',
            proctoringIframeUrl: this.params.proctoringIframeUrl,
            proctoringIframeHost: this.params.proctoringIframeHost,
            openId: this._openId
        });

        BEM.DOM.append(this.domElem, supervisor);

        this._checksCounter = 0;
        this._checkBlock = this.findBlockInside('hardware-check', 'check-hardware');
        this._checks = this._checkBlock.getSteps();

        this.bindTo(step.$recheck, 'pointerclick', this._checkHardwareStep.bind(this));

        this.bindTo('supervisor-ready', function () {
            BEM.blocks.supervisor.init(this.params.userProctoringToken);
        }.bind(this));

        this.bindTo('supervisor-inited', this._afterInitSupervisor.bind(this));
        this.bindTo('supervisor-init-error', this._onSupervisorInitError.bind(this));

        this.bindTo('supervisor-checked', function () {
            this._checkBlock.setSuccessState(this._checks[this._checksCounter]);

            this._checksCounter++;
            if (this._checksCounter < this._checks.length) {
                return this._checkHardwareStep();
            }

            this._afterHardwareCheck();
        }.bind(this));

        this.bindTo('supervisor-check-error', function (e, error) {
            var currentStepData = this._hardwareSteps[this._checksCounter];

            this._checkBlock.setFailedState(this._checks[this._checksCounter], error, currentStepData);
            this.delMod(step.$recheck, 'disabled');

            BH.lib.util.logger.info({
                error: error,
                place: 'Supervisor check error',
                openId: this._openId
            });
        }.bind(this));
    },

    /**
     * Добавляем обработчик смены размеров окна и переходим к проверке оборудования
     * @private
     */
    _afterInitSupervisor: function () {
        window.addEventListener('resize', function () {
            BEM.blocks.supervisor.resize();
        });

        this._checkHardwareStep();
    },

    /**
     * Шаг проверки оборудования
     * @private
     */
    _checkHardwareStep: function () {
        var step = this._steps[this._stepName];
        this.setMod(step.$recheck, 'disabled', 'yes');

        var checkStep = this._checks[this._checksCounter];
        var type = this._checkBlock.getStepType(checkStep);
        var check = {};
        check[type] = true;

        this._checkBlock.setProgressState(checkStep);
        BEM.blocks.supervisor.check(check);
    },

    /**
     * Действия после успешной проверки оборудования
     * @private
     */
    _afterHardwareCheck: function () {
        var step = this._steps[this._stepName];

        this.unbindFrom('supervisor-check-error');
        this.unbindFrom('supervisor-checked');
        step.button.delMod('disabled');
    },

    /**
     * Проверяет камеру с помощью SDK прокторинга
     * @private
     */
    _checkCamera: function () {
        var step = this._steps[this._stepName];
        this.bindTo(step.$recheck, 'pointerclick', this._recheckCamera.bind(this));

        this.bindTo('supervisor-checked', function () {
            this._hideSpinner(this._cameraSpinner, this._cameraSpin2, step.$step);
            this.trigger('identification-next');
        });

        this.bindTo('supervisor-check-error', function (e, error) {
            this._hideSpinner(this._cameraSpinner, this._cameraSpin2, step.$step);
            this.delMod(step.$error, 'disabled');
            this.delMod(step.$recheck, 'disabled');

            BH.lib.util.logger.info({
                error: error,
                place: 'Supervisor check camera error',
                openId: this._openId
            });
        });

        BEM.blocks.supervisor.check({ camera: true });
        this._showSpinner(this._cameraSpinner, this._cameraSpin2, step.$step);
    },

    /**
     * Перепроверяет камеру с помощью SDK прокторинга
     * @private
     */
    _recheckCamera: function () {
        var step = this._steps[this._stepName];

        this._showSpinner(this._cameraSpinner, this._cameraSpin2, step.$step);
        this.setMod(step.$error, 'disabled', 'yes');
        this.setMod(step.$recheck, 'disabled', 'yes');

        BEM.blocks.supervisor.check({ camera: true });
    },

    /**
     * Показывает блок с текущим шагом
     * @private
     */
    _showCurrentStep: function () {
        this.delMod(this._steps[this._stepName].$step, 'disabled');
    },

    /**
     * Скрывает блок с текущим шагом
     * @private
     */
    _hideCurrentStep: function () {
        this.setMod(this._steps[this._stepName].$step, 'disabled', 'yes');
    },

    /**
     * Показывает сделаный снимок с камеры
     * @param {jQuery} $snapshot
     * @param {String} image
     * @private
     */
    _showSnapshot: function ($snapshot, image) {
        if ($snapshot) {
            $snapshot.attr('src', image);
            this.delMod($snapshot, 'disabled');
        }
    },

    /**
     * Скрывает снимок с камеры
     * @param {jQuery} $snapshot
     * @private
     */
    _hideSnapshot: function ($snapshot) {
        if ($snapshot) {
            this.setMod($snapshot, 'disabled', 'yes');
        }
    },

    /**
     * Скрывает спиннер
     * @private
     */
    _hideSpinner: function (spinner, spin2, step) {
        if (spinner && spin2) {
            this.setMod(spinner, 'disabled', 'yes');
            this.delMod(step, 'radius');
            spin2.delMod('progress');
        }
    },

    /**
     * Показывает спиннер
     * @private
     */
    _showSpinner: function (spinner, spin2, step) {
        if (spinner && spin2) {
            spin2.setMod('progress', 'yes');
            this.setMod(step, 'radius', 'yes');
            this.delMod(spinner, 'disabled');
        }
    },

    /**
     * Сценарий действий после инициализации веб-камеры
     * @private
     */
    _onWebcamInit: function () {
        var step = this._steps[this._stepName];

        this._hideSnapshot(step.$snapshot);
        step.button.setMod('disabled', 'yes');
        this.setMod(step.$error, 'disabled', 'yes');
        this.setMod(step.$cover, 'disabled', 'yes');
        this.delMod(step.$coverBorder, 'disabled');
        step.$capture.text(BH.lib.i18n('common', 'make.photo'));
        this.unbindFrom(step.$capture, 'pointerclick');
        this.bindTo(step.$capture, 'pointerclick', this._capture.bind(this));
    },

    /**
     * Захват изображения с веб-камеры
     */
    _capture: function () {
        var captureCallback = this._stepName === 'face' ? this._uploadToProfile.bind(this, this._afterCapture) : this._afterCapture;
        BEM.blocks.webcam.capture(captureCallback, this);
    },

    _afterCapture: function (image) {
        var step = this._steps[this._stepName];

        this._hideSpinner(this._photoSpinner, this._photoSpin2, step.$step);

        step.button.delMod('disabled');
        this.delMod(step.$cover, 'disabled');
        this._photos[this._stepName] = image;
        this._showSnapshot(step.$snapshot, image);
        this._showRecapture(step);
    },

    /**
     * Показывает кнопку "Переснять"
     * @param step
     * @private
     */
    _showRecapture: function (step) {
        this.setMod(step.$coverBorder, 'disabled', 'yes');
        step.$capture.text(BH.lib.i18n('common', 'more.photo'));
        this.unbindFrom(step.$capture, 'pointerclick');
        this.bindTo(step.$capture, 'pointerclick', this._onWebcamInit.bind(this));
    },

    /**
     * Загружает фотографию пользователя в систему прокторинга
     * @private
     */
    _uploadToProfile: function (captureCallback, image) {
        var step = this._steps[this._stepName];

        this._showSpinner(this._photoSpinner, this._photoSpin2, step.$step);

        this.bindTo('supervisor-profile-saved', function () {
            captureCallback.call(this, image);
        });

        this.bindTo('supervisor-profile-error', function (e, error) {
            this._hideSpinner(this._photoSpinner, this._photoSpin2, step.$step);
            this.setMod(step.$cover, 'disabled', 'yes');
            this.delMod(step.$error, 'disabled');
            this._showRecapture(step);

            BH.lib.util.logger.info({
                error: error,
                place: 'Supervisor profile error',
                openId: this._openId
            });
        }.bind(this));

        BEM.blocks.supervisor.profile(image);
    },

    /**
     * Отправка фотографий на фронт-бэк
     * @private
     */
    _identificate: function () {
        var $step = this._steps[this._stepName].$step;

        this._showSpinner(this._photoSpinner, this._photoSpin2, $step);

        $.ajax({
            type: 'POST',
            url: this.params.identificationUrl,
            headers: {
                'x-csrf-token': this._sk
            },
            contentType: 'application/json',
            data: JSON.stringify(this._photos)
        })
            .done(this._onNext.bind(this))
            .fail(this._onLoadError.bind(this))
            .always(this._hideSpinner.bind(this, this._photoSpinner, this._photoSpin2, $step));
    },

    /**
     * При неудачной загрузке фото выводим сообщение об ошибке
     * @private
     */
    _onLoadError: function (error) {
        var message = BH.lib.i18n('errors', 'certificates-search.default');

        BEM.blocks['notifications-list'].notify(message);

        BH.lib.util.logger.info({
            error: error,
            place: 'Supervisor profile error',
            show: message,
            openId: this._openId
        });
    },

    /**
     * Ошибка инициализации супервизора
     * @private
     */
    _onSupervisorInitError: function (e, error) {
        var message = BH.lib.i18n('errors', 'supervisor.init');

        BEM.blocks['notifications-list'].notify(message);

        BH.lib.util.logger.info({
            error: error,
            place: 'Supervisor init error',
            show: message,
            openId: this._openId
        });
    },

    _showDocumentModal: function () {
        this._docExampleModal.setMod('visible', 'yes');
    },

    /**
     * При изменении значения чекбокса делаем кнопку активной
     * @private
     */
    _onCheckboxChange: function () {
        var step = this._steps[this._stepName];
        var button = step.button;

        if (!button) {
            return;
        }

        var isAllChecked = step.checkboxes.every(function (checkbox) {
            return checkbox.isChecked();
        });

        button.toggleMod('disabled', '', 'yes', isAllChecked);
    }
});
