module.exports = function (bh) {
    'use strict';
    bh.match('proctoring-footer_notifications_yes', function (ctx, json) {
        var data = json.data;

        if (!data) {
            return '';
        }

        ctx
            .js({
                formId: json.formId,
                messages: data.messages,
                attemptId: json.attemptId,
                maxErrorLevel: data.maxErrorLevel,
                hasNotifications: true,
                iframeInitError: data.iframeInitError,
                openId: json.openId
            })
            .content([
                {
                    elem: 'controls',
                    content: [
                        [
                            {
                                elem: 'indicators',
                                content: [
                                    {
                                        elem: 'indicator',
                                        mods: { type: 'video', color: 'green' }
                                    },
                                    {
                                        elem: 'indicator',
                                        mods: { type: 'audio', color: 'green' }
                                    },
                                    {
                                        elem: 'indicator',
                                        mods: { type: 'screen', color: 'green' }
                                    }
                                ]
                            }
                        ],
                        {
                            elem: 'report',
                            content: {
                                elem: 'report-icon'
                            }
                        },
                        {
                            block: 'popup2',
                            mods: {
                                theme: 'clear',
                                target: 'anchor',
                                visible: 'no',
                                type: 'notification'
                            },
                            directions: ['left-center'],
                            mainOffset: 22,
                            content: [
                                {
                                    block: 'proctoring-footer',
                                    elem: 'notifications',
                                    notifications: []
                                }
                            ]
                        },
                        {
                            block: 'modal',
                            mix: { block: 'proctoring-footer', elem: 'modal' },
                            mods: {
                                theme: 'normal',
                                autoclosable: 'yes',
                                visible: 'no'
                            }
                        }
                    ]
                },
                {
                    elem: 'face',
                    content: { block: 'proctoring-face' }
                }
            ], true);
    });

    bh.match('proctoring-footer__notifications', function (ctx, json) {
        var notifications = json.notifications;
        ctx.content({
            elem: 'notifications-content',
            notifications: notifications
        });
    });

    bh.match('proctoring-footer__notifications-content', function (ctx, json) {
        var notifications = json.notifications;

        if (!notifications.length) {
            return;
        }

        ctx.content(notifications.map(function (notification) {
            return {
                elem: 'notification',
                level: notification.level,
                type: notification.type,
                text: notification.text
            };
        }));
    });

    bh.match('proctoring-footer__notification', function (ctx, json) {
        var mods = { type: json.type + '-' + json.level };

        ctx
            .mods(mods)
            .content([
                {
                    elem: 'popup-icon',
                    mods: mods,
                    mix: { block: 'icon' }
                },
                {
                    elem: 'notification-text',
                    content: json.text
                }
            ]);
    });
};
