module.exports = function (bh) {
    'use strict';
    bh.match('proctoring-footer_notifications_no', function (ctx, json) {
        var data = json.data;

        if (!data) {
            return '';
        }

        ctx
            .js({
                formId: json.formId,
                messages: data.messages,
                attemptId: json.attemptId,
                maxErrorLevel: data.maxErrorLevel,
                hasNotifications: false,
                iframeInitError: data.iframeInitError
            })
            .content([
                {
                    elem: 'report',
                    content: [
                        {
                            block: 'icon',
                            mods: {
                                glyph: 'type-question'
                            }
                        },
                        {
                            elem: 'report-text',
                            content: data.problemsText
                        }
                    ]
                },
                {
                    block: 'popup2',
                    mods: {
                        theme: 'normal',
                        target: 'anchor',
                        visible: 'no',
                        type: 'notification'
                    },
                    directions: ['top-left']
                },
                {
                    block: 'modal',
                    mix: { block: 'proctoring-footer', elem: 'modal' },
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes',
                        visible: 'no'
                    }
                }
            ]);
    });
};
