/* global gemini */
'use strict';

gemini.suite('one-answer', function (suite) {
    suite
        .setCaptureElements('.question_test_one-answer')
        .capture('plain')
        .capture('choose-answer', function (actions, find) {
            var radioButton = find('.radiobox__radio');
            actions
                .mouseMove(radioButton)
                .click(radioButton)
                .wait(500);
        })
        .capture('show-popup', function (actions, find) {
            var helpButton = find('.question_test_one-answer .question__help-button');
            actions
                .mouseMove(helpButton)
                .click(helpButton)
                .wait(1000);
        });
});

gemini.suite('answers-many', function (suite) {
    suite
        .setCaptureElements('.question_test_answers-many')
        .capture('plain')
        .capture('choose-answer', function (actions, find) {
            var checkbox = find('.checkbox__box');
            actions
                .mouseMove(checkbox)
                .click(checkbox)
                .wait(500);
        })
        .capture('show-popup', function (actions, find) {
            var helpButton = find('.question_test_answers-many .question__help-button');
            actions
                .mouseMove(helpButton)
                .click(helpButton)
                .wait(1000);
        });
});
