module.exports = function (bh) {
    bh.match('rules-list', function (ctx, json) {
        var items = json.items;

        if (!items || items.length === 0) {
            return '';
        }

        ctx
            .tag('ol')
            .content(items.map(function (item) {
                return item && {
                    tag: 'li',
                    elem: 'item',
                    mix: { elem: 'ellipsis' },
                    content: [
                        {
                            elem: 'item-icon',
                            tag: 'img',
                            attrs: {
                                src: item.icon
                            }
                        },
                        {
                            elem: 'item-text',
                            content: item.text
                        }
                    ]
                };
            }));
    });
};
