BEM.DOM.decl('supervisor', {
    onSetMod: {
        js: {
            inited: function () {
                var identification = this.findBlockOutside('identification');
                var question = this.findBlockOutside('question');
                var iframe = window.frames.supervisor_frame;

                if (!iframe) {
                    return;
                }

                this._parent = identification || question;
                this._openId = this.params.openId;
                this.__self._iframe = iframe;
                this.__self._proctoringIframeHost = this.params.proctoringIframeHost;

                this.bindToWin('message', this._onIframeMessage.bind(this));
            }
        }
    },

    _onIframeMessage: function (e) {
        var parent = this._parent.domElem;
        var data = e.originalEvent.data;

        if (e.originalEvent.origin !== this.params.proctoringIframeHost) {
            return;
        }

        try {
            data = JSON.parse(data);
        } catch (error) {
            BH.lib.util.logger.info({
                error: error.message,
                place: 'Can not parse iframe message',
                openId: this._openId
            });

            return;
        }

        parent.trigger(data.event, data.payload);
    }
}, {
    _sendMessageToIframe: function (method, options) {
        var data = JSON.stringify({ method: method, options: options });
        this._iframe.postMessage(data, this._proctoringIframeHost);
    },

    /**
     * Создание супервизора
     */
    create: function () {
        this._sendMessageToIframe('create');
    },

    /**
     * Регистрация пользователя и сессии в прокторинге
     * @param token
     */
    init: function (token) {
        this._sendMessageToIframe('init', token);
    },

    /**
     * Проверка оборудования
     * @param options
     */
    check: function (options) {
        this._sendMessageToIframe('check', options);
    },

    /**
     * Получение файла снимка с камеры
     * @param video
     * @param options
     * @returns {*}
     */
    snapshot: function (video, options) {
        this._sendMessageToIframe('snapshot', { video: video, options: options });
    },

    /**
     * Сохранение фотографии пользователя в профиль
     * @param face Фотография лица в base64
     * @returns {*}
     */
    profile: function (face) {
        this._sendMessageToIframe('profile', { image: face });
    },

    /**
     * Начало сессии прокторинга
     * @returns {*}
     */
    start: function () {
        this._sendMessageToIframe('start');
    },

    stop: function () {
        this._sendMessageToIframe('stop');
    },

    /**
     * Восстановление сессии (например, после перезагрузки страницы)
     */
    sync: function () {
        this._sendMessageToIframe('sync');
    },

    /**
     * Запрос доступов до камеры и микрофона
     */
    getmedia: function () {
        this._sendMessageToIframe('getmedia');
    },

    /**
     * Отправка новых размеров окна
     */
    resize: function () {
        this._sendMessageToIframe('resize', {
            outerWidth: window.outerWidth,
            outerHeight: window.outerHeight
        });
    }
});
