BEM.DOM.decl('webcam', {
    onSetMod: {
        js: {
            inited: function () {
                this.__self._attemptsCount = 100;
            }
        }
    }
}, {

    /**
     * Инициализация Webcam.js
     * @param {String} cameraSelector
     * @param {Function} callback
     * @param {Object} ctx
     */
    init: function (cameraSelector, callback, ctx) {
        this._attemptsCount -= 1;

        if (window.Webcam) {
            Webcam.set('swfURL', 'https://yastatic.net/s3/vda/i/webcam.swf');
            Webcam.set('flip_horiz', true); // Отзеркаливаем видео, чтобы было проще фотографироваться
            Webcam.attach(cameraSelector);

            if (callback) {
                callback.call(ctx);
            }
        } else if (this._attemptsCount > 0) {
            setTimeout(this.init.bind(this), 100, cameraSelector, callback, ctx);
        } else {
            throw new Error('Cannot initialize Webcam.js');
        }
    },

    /**
     * Захват фото с вебкамеры
     * Функция-callback принимает на вход фото - строку в формате base64
     * @param {Function<String>} callback
     * @param {Object} ctx
     */
    capture: function (callback, ctx) {
        /* Прокторинг не зеркалит видео с камеры.
         Делаем неотзеркаленное фото, чтобы оно совпадало с видео с камеры, и чтобы текст в документе был читаемый */
        Webcam.set('flip_horiz', false);
        Webcam.snap(function (image) {
            Webcam.set('flip_horiz', true);
            callback.call(ctx, image);
        });
    }
});
