module.exports = function (bh) {
    'use strict';

    var rules = {
        width: value => `width:${value}px;`,
        height: value => `height:${value}px;`,
        padding: value => `padding:${value};`
    };

    bh.match('size-wrapper', function (ctx, json) {
        var style = Object
            .keys(rules)
            .map(name => json[name] ? rules[name](json[name]) : '')
            .join('');

        ctx.attr('style', style);
    });
};
