const platforms = ['desktop', 'touch-phone'];
const Gemini = require('gemini/api');
const Promise = require('bluebird');
const upload = require('./gemini-upload');

module.exports = (function runner() {
    'use strict';
    Promise
        .each(platforms, platform => {
            return upload(`${__dirname}/${platform}.gemini/`)
                .then(function (url) {
                    const config = require(`./.gemini.${platform}.json`);
                    config.system.projectRoot = `${__dirname}`;
                    config.rootUrl = url;

                    return new Gemini(config)
                        .test([`${__dirname}/${platform}.gemini/common/_common.gemini.js`], { reporters: ['html', 'flat'] });
                })
                .then(result => {
                    if (result.failed > 0 || result.errored > 0) {
                        return Promise.reject(2);
                    }
                    return 0;
                });
        })
        .catch(err => exit(err));

    function exit(code) {
        process.on('exit', function () {
            process.exit(code);
        });
    }
})();
