module.exports = function (bh) {
    'use strict';
    bh.match('attempt-time__text', function () {
        return '';
    });

    bh.match('attempt-time__time', function (ctx, json) {
        ctx
            .mix({
                block: 'i-font',
                mods: {
                    face: 'yandex-sans-text-thin'
                }
            })
            .content([
                json.time,
                {
                    block: 'popup2',
                    mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' },
                    mainOffset: 10,
                    directions: ['bottom-right'],
                    content: [
                        { elem: 'tail' },
                        {
                            elem: 'content',
                            mods: { type: 'time' },
                            content: bh.lib.i18n('common', 'attempt.time.tip')
                        }
                    ]
                }
            ]);
    });
};
