module.exports = function (bh) {
    'use strict';

    bh.match('cert-share__share', function (ctx, json) {
        var hideShare = json.hideShare;
        var content = {
            block: 'share',
            options: json.options
        };

        if (!hideShare) {
            ctx.content(content);
            return;
        }

        ctx.content({
            block: 'popup2',
            mods: {
                target: 'anchor',
                theme: 'normal',
                autoclosable: 'yes',
                source: 'cert-share'
            },
            content: [
                { elem: 'tail' },
                bh.utils.extend(
                    {},
                    content,
                    {
                        mods: { page: 'my-certificates' }
                    }
                )
            ]
        });
    });

    bh.match('cert-share__download', function (ctx, json) {
        ctx.content({
            block: 'button2',
            mods: {
                type: 'link',
                theme: 'normal',
                size: 's'
            },
            url: json.url,
            text: bh.lib.i18n('common', 'cert.download'),
            target: '_blank'
        });
    });

    bh.match('cert-share__get-code', function (ctx) {
        ctx.content([
            {
                block: 'button2',
                mods: {
                    theme: 'normal',
                    size: 's'
                },
                text: bh.lib.i18n('cert', 'get-code')
            }
        ]);
    });
};
