module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./certificates-search-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'i-global',
                    params: {
                        browser: 'ChromeMobile',
                        isMobile: true
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'empty' },
                    content: {
                        block: 'certificates-search'
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'filled' },
                    content: {
                        block: 'certificates-search',
                        cert: data.filled
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'wrong' },
                    padding: '2px 0',
                    content: {
                        block: 'certificates-search',
                        cert: data.wrong
                    }
                }
            ]
        };
    });
};
