module.exports = function (bh) {
    'use strict';
    bh.match('exam-start__time-limit', function (ctx, json) {
        ctx.content([
            bh.lib.i18n('common', 'exam.time'),
            '&nbsp;&mdash;&nbsp;',
            json.timeLimit
        ]);
    });

    bh.match('exam-start__auth', function (ctx) {
        var global = bh.lib.global;
        ctx.content({
            block: 'button2',
            mods: {
                theme: 'normal',
                size: 'l',
                type: 'link',
                width: 'max'
            },
            text: bh.lib.i18n('common', 'user.enter'),
            url: global['passport-host'] + '/auth?retpath=' + encodeURIComponent(global.retpath)
        });
    });

    bh.match('exam-start__restriction_type_disabled-for-mobile', function (ctx) {
        ctx.content(bh.lib.i18n('common', 'exam.disabled-for-mobile'));
    });

    bh.match('modal__terms-additions', function (ctx, json) {
        ctx.content(json.additions.map(function (addition) {
            return {
                elem: 'addition',
                content: {
                    elem: 'addition-text',
                    mix: { block: 'html-content' },
                    content: addition.text
                }
            };
        }));
    });

    bh.match('modal__terms-clearly', function (ctx, json) {
        ctx.content({
            block: 'button2',
            mods: {
                theme: 'action',
                width: 'max',
                type: 'link',
                size: 'l'
            },
            url: json.attemptUrl,
            text: bh.lib.i18n('common', 'exam.clearly')
        });
    });
};
