module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./exam-start-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'i-global',
                    params: {
                        isMobile: true
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'enabled' },
                    content: {
                        block: 'exam-start',
                        exam: data.enabled.exam,
                        examAccess: data.enabled.examAccess,
                        isAuthorized: data.enabled.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'frozen' },
                    content: {
                        block: 'exam-start',
                        exam: data.frozen.exam,
                        examAccess: data.frozen.examAccess,
                        isAuthorized: data.frozen.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'disabled' },
                    content: {
                        block: 'exam-start',
                        exam: data.disabled.exam,
                        examAccess: data.disabled.examAccess,
                        isAuthorized: data.disabled.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'continued' },
                    content: {
                        block: 'exam-start',
                        exam: data.continued.exam,
                        examAccess: data.continued.examAccess,
                        isAuthorized: data.continued.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'unauthorized' },
                    content: {
                        block: 'exam-start',
                        exam: data.unauthorized.exam,
                        examAccess: data.unauthorized.examAccess,
                        isAuthorized: data.unauthorized.isAuthorized,
                        passportProfile: '#'
                    }
                },
                {
                    block: 'size-wrapper',
                    mods: { type: 'disabled-for-mobile' },
                    content: {
                        block: 'exam-start',
                        exam: data.disabledForMobile.exam,
                        examAccess: data.disabledForMobile.examAccess,
                        isAuthorized: data.disabledForMobile.isAuthorized,
                        passportProfile: '#'
                    }
                }
            ]
        };
    });
};
