module.exports = function (bh) {
    'use strict';
    bh.match('head', function (ctx, json) {
        var userInfo = json.userInfo || {};

        ctx
            .tag('header')
            .content([
                {
                    elem: 'logo',
                    url: json.mordaHost
                },
                {
                    elem: 'right-column',
                    content: [
                        {
                            block: 'user',
                            login: userInfo.login,
                            uid: userInfo.uid,
                            mods: {
                                menu: 'multiauth',
                                expert: 'yes'
                            },
                            content: { elem: 'icon', avatarId: json.avatarId }
                        }
                    ]
                }
            ]);
    });
};
