module.exports = function (bh) {
    'use strict';
    bh.match('layout', function (ctx, json) {
        if (json.left) {
            ctx.js(true);
        }
    });

    bh.match('layout__content', function (ctx, json) {
        var left = json.left;
        var right = json.right;

        ctx.content([
            left && [
                {
                    block: 'paranja',
                    mods: { autoclosable: 'yes', name: 'left-column' },
                    js: {
                        rel: [
                            { elem: '.paranja_name_left-column', event: 'pointerclick', method: 'close' }
                        ]
                    }
                },
                {
                    elem: 'left',
                    data: left
                },
                {
                    elem: 'button'
                }
            ],
            right && {
                elem: 'right',
                data: right
            }
        ]);
    });

    bh.match('layout__button', function (ctx) {
        ctx.content({
            block: 'button2',
            mods: { size: 'l', theme: 'normal' },
            content: {
                block: 'icon',
                mods: { type: 'hamburger' },
                mix: { block: 'button2', elem: 'icon' }
            }
        });
    });
};
