BEM.DOM.decl('main-menu', {
    onSetMod: {
        js: function () {
            this._initial();
            this._sidebar.on('open', this._handleOpenSidebar.bind(this));
            this._sidebar.on('close', this._handleCloseSidebar.bind(this));
        }
    },

    _canChangeHeadColor: true,

    _handleOpenSidebar: function () {
        this._canChangeHeadColor = false;
        this._isOpenSidebar = true;
        this.delMod(this.elem('head'), 'theme');
    },

    _handleCloseSidebar: function () {
        this._canChangeHeadColor = true;
        this._isOpenSidebar = false;

        if (this._isPressed) {
            this.setMod(this.elem('head'), 'theme', 'red');
        }
    },

    _pressHead: function (headMargin) {
        this._headBlock.setMod('hidden', 'yes');

        if (this._canChangeHeadColor && headMargin === this._maxHeadMargin) {
            this.setMod(this.elem('head'), 'theme', 'red');

            this._isPressed = true;
        }
    },

    _pressDownHead: function () {
        this._headBlock.delMod('hidden');

        this.delMod(this.elem('head'), 'theme');

        this._isPressed = false;
    }
});
