module.exports = function (bh) {
    'use strict';
    bh.match('question__buttons', function (ctx) {
        ctx.content([
            {
                block: 'button2',
                mods: { theme: 'action', size: 'm', disabled: 'yes' },
                text: bh.lib.i18n('common', 'attempt.button.answer')
            },
            {
                block: 'button2',
                mods: { theme: 'pseudo', size: 'm' },
                text: bh.lib.i18n('common', 'attempt.button.skip')
            },
            {
                elem: 'help-button',
                content: '?'
            },
            {
                elem: 'spin',
                content: {
                    block: 'spin2',
                    mods: {
                        size: 'm',
                        progress: 'yes'
                    }
                }
            },
            {
                block: 'popup2',
                mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' },
                mainOffset: 20,
                directions: ['top-right'],
                content: [
                    { elem: 'tail' },
                    {
                        elem: 'content',
                        content: bh.lib.i18n('common', 'attempt.tip')
                    }
                ]
            }
        ]);
    });
};
