module.exports = function (bh) {
    'use strict';
    bh.match('search-form__input', function (ctx, json) {
        ctx.content({
            block: 'input',
            mods: { size: 'm', type: json.type, clear: 'no' },
            placeholder: json.placeholder,
            content: { elem: 'control' },
            value: json.value
        });
    });

    bh.match('search-form__button', function (ctx, json) {
        ctx.content({
            block: 'button2',
            mods: {
                theme: 'action',
                size: 'l',
                disabled: json.disabled ? '' : 'yes',
                width: 'max'
            },
            text: bh.lib.i18n('common', 'certificates-search.action')
        });
    });
};
