BEM.DOM.decl('sidebar-dimmer', {
    onSetMod: {
        js: function () {
            this.bindTo(this.domElem, 'pointerclick', this._handleClick.bind(this));
            var bPage = this.findBlockOutside('b-page');

            this._sidebar = bPage.findBlockInside('sidebar');

            this._sidebar.on('open', this._handleOpenSidebar.bind(this));
            this._sidebar.on('close', this._handleCloseSidebar.bind(this));

            this.bindTo('touchmove touchstart scroll', this._stopScroll.bind(this));
        }
    },

    _stopScroll: function (e) {
        e.preventDefault();
    },

    _handleClick: function () {
        this._sidebar.trigger('close');
        this.setMod('active', 'no');
    },

    _handleCloseSidebar: function () {
        this.setMod('active', 'no');
    },

    _handleOpenSidebar: function () {
        this.setMod('active', 'yes');
    }
});
