module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var startTime = new Date();
        startTime.setHours(startTime.getHours() - 1);

        var serverTime = new Date();
        serverTime.setHours(serverTime.getHours() + 1);

        return {
            block: blockName,
            content: [
                {
                    block: 'subhead',
                    content: [
                        {
                            block: 'attempt-progress',
                            countAnswered: 0,
                            questionCount: 43
                        },
                        {
                            block: 'attempt-time',
                            started: startTime.toString(),
                            timeLimit: 1800000,
                            serverTime: serverTime.toString()
                        }
                    ]
                }
            ]
        };
    });
};
