module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./table-nock.json');
        var archive = data.archive;
        var result = data.result;
        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    mods: { test: 'archive' },
                    content: [
                        {
                            block: 'table',
                            mods: { type: 'archive' },
                            head: archive.head,
                            body: archive.body
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { test: 'result' },
                    content: [
                        {
                            block: 'table',
                            mods: { type: 'result' },
                            title: result.title,
                            head: result.head,
                            body: result.body
                        }
                    ]
                }
            ]
        };
    });
};
