/* global BEM */
module.exports = function (blocks) {
    var js = [
        { url: 'https://yastatic.net/jquery/1.12.0/jquery.min.js' },
        { url: '../../common/_common.js' }
    ];

    var css = [
        { url: '../../common/_common.css' }
    ];

    var meta = [
        { 'http-equiv': 'X-UA-Compatible', content: 'IE=edge' }
    ];

    blocks.declare('gemini-page', function (options) {
        BEM.I18N.lang('ru');

        return [
            {
                block: 'i-global',
                params: {
                    lang: 'ru'
                }
            },
            '<!DOCTYPE html>',
            {
                tag: 'html',
                mix: { block: 'i-ua', mods: { js: 'no' }},
                content: [
                    {
                        tag: 'head',
                        content: [

                            { tag: 'meta', attrs: { charset: 'utf-8' }},

                            meta.map(function (attrs) {
                                return { tag: 'meta', attrs: attrs };
                            }),

                            { tag: 'title', content: options.title },

                            css.map(function (file) {
                                return { block: 'gemini-page', elem: 'css', file: file };
                            })
                        ]
                    },
                    {
                        tag: 'body',
                        block: 'gemini-page',
                        elem: 'body',
                        mix: [
                            {
                                block: 'i-global',
                                js: {
                                    tld: 'ru'
                                }
                            },
                            { block: 'b-page' },
                            { block: 'b-page', elem: 'body' }
                        ],
                        content: [
                            {
                                elem: 'inner',
                                mix: [
                                    { block: 'b-page', elem: 'inner' }
                                ],
                                content: blocks.exec(options.blockName)
                            },
                            js.map(function (file) {
                                return { block: 'gemini-page', elem: 'js', file: file };
                            })
                        ]
                    }
                ]
            }
        ];
    });
};
