'use strict';
/* eslint-disable no-console */

const _ = require('lodash');
const bunkerToJs = require('bunker-to-js');
const config = require('cfg');
const fs = require('fs');
const path = require('path');
const log = require('./../server/logger');

const start = Date.now();
const opts = _.assign({}, config.bunker, {
    parsers: [
        require('bunker-filter').hidden,
        require('bunker-filter').empty,
        require('bunker-avatar'),
        require('bunker-tjson'),
        require('bunker-json'),
        require('bunker-cat')
    ]
});

log.info('Fetch data from Bunker...');

const request = function (retries) {
    let bunker = bunkerToJs(opts);

    opts.parsers.forEach(bunker.parse.bind(bunker));

    return bunker
        .then()
        .catch(err => {
            if (retries <= 0) {
                throw err;
            }
            retries--;
            log.error(`Retries left: ${retries}`);
            return request(retries);
        });
};

request(5)
    .then(obj => {
        const dir = './server/mock';

        if (!fs.existsSync(dir)) {
            fs.mkdirSync(dir);
        }

        const filePath = path.join(dir, 'bunker.json');

        fs.writeFile(filePath, JSON.stringify(obj), err => {
            if (err) {
                throw err;
            }
            log.info(`Bunker saved to ${filePath} - ${Date.now() - start}ms`);
        });
    })
    .catch(err => {
        log.error(err, 'Bunker fetching error');
    });
