import { configure, addDecorator } from '@storybook/react';
import React from 'react';
import { Provider as StoreProvider } from 'react-redux';
import { BrowserRouter } from 'react-router-dom';

import configureStore from '../client/store';

import '../client/bundles/main.css';

const req = require.context('../client', true, /\.stories\.tsx?$/);

function loadStories() {
    req.keys().forEach(filename => req(filename));
}

addDecorator(story => (
    <BrowserRouter>
        <StoreProvider store={configureStore()}>
            {story()}
        </StoreProvider>
    </BrowserRouter>
));

configure(loadStories, module);
