const path = require('path');

const TsconfigPathsPlugin = require('tsconfig-paths-webpack-plugin');
const postcssCustomProperties = require('postcss-custom-properties');
const postcssImport = require('postcss-import');
const postcssPrependImports = require('postcss-prepend-imports');
const postcssReporter = require('postcss-reporter');
const postcssPresetEnv = require('postcss-preset-env');
const postcssNested = require('postcss-nested');

const include = path.resolve(__dirname, '../');
const clientDir = path.resolve(include, 'client');

module.exports = {
    resolve: {
        extensions: ['.ts', '.tsx', '.js'],
        plugins: [new TsconfigPathsPlugin()]
    },
    module: {
        rules: [
            {
                test: /\.tsx?$/,
                loader: 'ts-loader',
                exclude: /node_modules/,
                include
            },
            {
                test: /\.css$/,
                use: [
                    'style-loader',
                    'css-loader',
                    {
                        loader: 'postcss-loader',
                        options: {
                            plugins: [
                                postcssPrependImports({
                                    path: path.resolve(clientDir, 'common'),
                                    files: ['media.css', 'variables.css']
                                }),
                                postcssImport(),
                                postcssNested(),
                                postcssCustomProperties({ preserve: false }),
                                postcssPresetEnv({
                                    features: {
                                        'nesting-rules': true,
                                        'custom-media-queries': true
                                    }
                                }),
                                postcssReporter()
                            ]
                        }
                    }
                ],
            },
            {
                test: /\.svg$/,
                loader: 'svg-url-loader'
            },
            {
                test: /^(?!.*\.inline).*\.(jpe?g|png|gif|eot|woff2?|ttf)$/,
                loader: 'file-loader'
            },
            {
                test: /\.i18n\//,
                loader: 'webpack-bem-i18n-loader'
            }
        ]
    }
};
