/// <reference path="./@types/express/index.d.ts" />

declare module 'express-bunker' {
    import { GotOptions } from 'got';
    import { RequestHandler } from 'express';

    type Parser = (node: any, next: () => void) => void;

    export interface ExpressBunkerOptions extends GotOptions<string | null> {

        /** API endpoint */
        api: string,

        /** Project name */
        project: string,

        /** Version of bunker nodes (Default: latest) */
        version?: string,

        /** Update interval in milliseconds (Default: 5000) */
        updateInterval?: number,

        /** `true` if directories content should be loaded (Default: true) */
        directories?: boolean,

        /** `true` if bunker-cache should be enabled (Default: true) */
        cache?: boolean,

        /**
         * `true` if data should be deep freezed (Default: false). Incompatible with `cache: true`
         *
         * See:
         * https://developer.mozilla.org/ru/docs/Web/JavaScript/Reference/Global_Objects/Object/freeze
         */
        freeze?: boolean,

        /**
         * Array of bunker-to-js parsers
         * (Default: [
         *    BunkerToJs.filter.hidden,
         *    BunkerToJs.filter.empty,
         *    BunkerToJs.avatar,
         *    BunkerToJs.tjson,
         *    BunkerToJs.json,
         *    BunkerToJs.cat
         * ])
         *
         * See:
         * https://github.yandex-team.ru/toolbox/bunker-to-js/#parsers
         */
        parsers?: Parser[],

        /** Property name where data should be stored (Default: bunker) */
        propertyName?: string
    }

    /**
     * Loads data from bunker project into req.bunker
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-bunker
     */
    function expressBunker(options?: ExpressBunkerOptions): RequestHandler;

    export default expressBunker;
}
