/// <reference path="./@types/express/index.d.ts" />

declare module 'express-http-geobase' {
    import { GotOptions } from 'got';
    import { RequestHandler } from 'express';

    interface Location {
        lon: number,
        lat: number
    }

    /* eslint-disable camelcase */
    export interface Geolocation {

        /** User region id. */
        region_id: number, // eslint-disable-line camelcase

        /** User region id determined by ip. */
        region_id_by_ip: number, // eslint-disable-line camelcase

        /** Suspected user region id. */
        suspected_region_id: number, // eslint-disable-line camelcase

        /**
         * Precision of user location.
         *
         * 0 — Unknown precision;
         * 1 — Determination up to a concrete WiFi-point;
         * 2 — Determination up to a concrete city;
         * 3 — Determination up to other unit of territorial division;
         * 4 — Determination up to concrete country;
         * 5 — Determination of the capital with an adjustment
         *     to a more important (from the point of view of Yandex) city.
         */
        precision: number,

        /**
         * Precision of user location determined by ip.
         *
         * 0 — Unknown precision;
         * 1 — Determination up to a concrete WiFi-point;
         * 2 — Determination up to a concrete city;
         * 3 — Determination up to other unit of territorial division;
         * 4 — Determination up to concrete country;
         * 5 — Determination of the capital with an adjustment
         *     to a more important (from the point of view of Yandex) city.
         */
        precision_by_ip: number, // eslint-disable-line camelcase

        /** User point id. */
        point_id: number, // eslint-disable-line camelcase

        /** The need to set the newly calculated values to the cookie. */
        should_update_cookie: boolean, // eslint-disable-line camelcase

        /** `true` if user has manually defined his region at tune.yandex.ru. */
        gid_is_trusted: boolean, // eslint-disable-line camelcase

        /**
         * Refined user region id.
         * For example, if region determined by ip have accuracy up to a concrete city,
         * then the `region_id_by_gp` can point to the district or even the metro station.
         */
        region_id_by_gp: number, // eslint-disable-line camelcase

        /** `true` if user region id is equals to region id of Yandex internal network. */
        is_yandex: boolean, // eslint-disable-line camelcase

        /** Array of parent region ids. */
        parents: number[],

        /** Geographic coordinates of the user's location. */
        location: Location
    }
    /* eslint-enable camelcase */

    export interface ExpressHttpGeobaseOptions {
        clientOptions?: GotOptions<string | null>

        /** API endpoint (http://geobase.qloud.yandex.ru by default) */
        server?: string
    }

    /**
     * Detects user geolocation into req.geolocation
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-http-geobase
     */
    function expressHttpGeobase(options?: ExpressHttpGeobaseOptions): RequestHandler;

    export default expressHttpGeobase;
}
