/// <reference path="./@types/express/index.d.ts" />

declare module 'express-http-langdetect' {
    import { GotOptions } from 'got';
    import { Request, RequestHandler } from 'express';

    interface AvailableLanguagesObject {
        [tld: string]: string | string[]
    }

    type AvailableLanguagesFunction = (req: Request) =>
        string | string[] | AvailableLanguagesObject;

    export interface Language {
        id: string,
        name: string
    }

    export interface ExpressHttpLangdetectOptions {
        clientOptions?: GotOptions<string | null>,

        /** Default service language */
        defaultLanguage?: string,

        /**
         * This language is returned in case of errors if defaultLanguage is not set.
         * Defaults to {id: "ru", name: "Ru"}
         *
         * Set to false if you don't need any fallback value at all
         */
        fallbackLanguage: boolean | Language

        /** Add list of user-relevant languages to req.langdetect.list object */
        list?: boolean,

        /**
         * Available languages can be one of the following:
         *   1. String, that contains all language codes (ids) split with ',' sign (i.e. 'en,ru,tr')
         *
         *   2. Array, that contains language codes, that is joined using ',' to get a string
         *      described above
         *
         *   3. Object, that has service TLDs as keys and arrays or strings in format
         *      described above
         *
         *   4. Function, that accepts express request object and should return any of the above.
         */
        availableLanguages?: string | string[] | AvailableLanguagesObject | AvailableLanguagesFunction, // eslint-disable-line max-len

        /** API endpoint (http://langdetect.qloud.yandex.ru by default) */
        server?: string
    }

    /**
     * Detects user language into req.langdetect
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-http-langdetect
     */
    function expressHttpLangdetect(options?: ExpressHttpLangdetectOptions): RequestHandler;

    export default expressHttpLangdetect;
}
