/// <reference path="./@types/express/index.d.ts" />

declare module 'express-http-uatraits' {
    import { GotOptions } from 'got';
    import { RequestHandler } from 'express';

    export interface ExpressHttpUatraitsOptions {
        clientOptions?: GotOptions<string | null>

        /** API endpoint (http://uatraits.qloud.yandex.ru by default) */
        server?: string
    }

    /**
     * Parses user agent header into req.uatraits
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-http-uatraits
     */
    function expressHttpUatraits(options?: ExpressHttpUatraitsOptions): RequestHandler;

    export default expressHttpUatraits;
}
