/// <reference path="./@types/express/index.d.ts" />

declare module 'express-secretkey' {
    import { Request, RequestHandler } from 'express';

    export interface ExpressSecretkeyOptions {

        /**
         * HTTP methods which will be ignored when checking secret token
         *
         * Default: ['GET', 'HEAD', 'OPTIONS']
         */
        ignoreMethods?: string[]

        /**
         * Function to get secret token from request object
         *
         * Default:
         * ```
         * req => (req.body && req.body.sk) ||
         *     (req.query && req.query.sk) ||
         *     req.headers['csrf-token'] ||
         *     req.headers['xsrf-token'] ||
         *     req.headers['x-csrf-token'] ||
         *     req.headers['x-xsrf-token'];
         * ```
         */
        value?: (req: Request) => string
    }

    /**
     * Generate secret token into req.secretkey
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-secretkey
     */
    function expressSecretkey(options?: ExpressSecretkeyOptions): RequestHandler & {

        /**
         * Validate token with respect to `ignoreMethods`
         */
        validate: RequestHandler;
    };

    export default expressSecretkey;
}
