declare module 'express-x-forwarded-for-fix' {
    import { GotOptions } from 'got';
    import { RequestHandler } from 'express';

    export interface ExpressXForwardedForFixOptions {

        /** Default IP if others has been filtered (useful for debug) */
        defaultIP?: string

        /**
         * Filter reserved IPv4s
         *
         * See:
         * https://github.yandex-team.ru/toolbox/express-x-forwarded-for-fix/blob/master/index.js
         */
        filterReserved?: boolean
    }

    /**
     * Filters inccorect IPs from x-forwarded-for header
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-x-forwarded-for-fix/
     */
    function expressXForwardedForFix(options?: ExpressXForwardedForFixOptions): RequestHandler;

    export default expressXForwardedForFix;
}
