declare module 'express-yandexuid' {
    import { GotOptions } from 'got';
    import { RequestHandler } from 'express';

    export interface ExpressYandexuidOptions {

        /** Cookie expires directive (10 years by default) */
        expires?: number

        /** Cookie domain directive (.yandex.{tld} by default) */
        yaDomain?: string
    }

    /**
     * Sets yandexuid cookie
     *
     * See:
     * https://github.yandex-team.ru/toolbox/express-yandexuid
     */
    function expressYandexuid(options?: ExpressYandexuidOptions): RequestHandler;

    export default expressYandexuid;
}
