declare module 'yandex-cfg' {
    import { ExpressBlackboxOptions } from 'express-blackbox';
    import { ExpressBunkerOptions } from 'express-bunker';
    import { ExpressHttpGeobaseOptions } from 'express-http-geobase';
    import { ExpressHttpLangdetectOptions } from 'express-http-langdetect';
    import { ExpressHttpUatraitsOptions } from 'express-http-uatraits';
    import { ExpressSecretkeyOptions } from 'express-secretkey';
    import { IOptions as ExpressTvmOptions } from '@yandex-int/express-tvm';
    import {
        ExpressXForwardedForFixOptions
    } from 'express-x-forwarded-for-fix';
    import { ExpressYandexCspOptions } from 'express-yandex-csp';
    import { ExpressYandexuidOptions } from 'express-yandexuid';
    import { IHelmetConfiguration } from 'helmet';
    import { LoggerOptions } from 'yandex-logger';

    import IExam from 'common/types/exam';
    import Dictionary from 'common/types/dictionary';
    import { Roles } from 'common/types/adminData';

    interface Config {

        /**
         * Options for express-blackbox
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-blackbox
         */
        blackbox: ExpressBlackboxOptions,

        /**
         * Options for express-bunker middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-bunker
         */
        bunker?: ExpressBunkerOptions,

        /**
         * Options for express-yandex-csp middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-yandex-csp
         */
        csp?: ExpressYandexCspOptions,

        /**
         * Options for helmet middleware
         *
         * Source code:
         * https://github.com/helmetjs/helmet
         */
        helmet?: IHelmetConfiguration,

        /**
         * Options for express-http-geobase middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-http-geobase
         */
        httpGeobase?: ExpressHttpGeobaseOptions,

        /**
         * Options for express-http-langdetect middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-http-langdetect
         */
        httpLangdetect?: ExpressHttpLangdetectOptions,

        /**
         * Options for express-http-uatraits middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-http-uatraits
         */
        httpUatraits?: ExpressHttpUatraitsOptions,

        /** Languages for which source code should be built */
        langs: string[],

        /**
         * Options for yandex-logger
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/yandex-logger
         */
        logger: LoggerOptions,

        /** Render options */
        render?: {

            /** Turns hot module replacement */
            isHot: boolean
        },

        /**
         * Options for express-secretkey middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-secretkey
         */
        secretkey?: ExpressSecretkeyOptions

        /** Static content (built css and js, images, etc) options */
        static: {

            /** Base url for static content (e.g. https://yastatic.net/s3/project-stub/) */
            baseUrl: string,

            /** Directory for the built static content */
            dir: string,

            /** Path to frozen (version agnostic) static content (e.g. "_") */
            frozenPath: string,

            /** Directory for static files, which should be served from / */
            staticDir: string,

            /** Path to version static content (usually picked from env) */
            version: string
        },

        /**
         * Options for express-tvm middleware
         *
         * More information:
         * https://wiki.yandex-team.ru/passport/tvm2/qloud/#/tvm/tickets
         */
        tvm: ExpressTvmOptions,

        /**
         * Options for express-x-forwarded-for-fix middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-x-forwarded-for-fix
         */
        xForwardedForFix?: ExpressXForwardedForFixOptions,

        /**
         * Options for express-yandexuid middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-yandexuid
         */
        yandexuid?: ExpressYandexuidOptions
    }

    interface ExpertOfficeConfig extends Config {
        defaultAvatarSrc: string,

        api: {
            protocol: string,
            host: string,
            pathname: string,
            reportPath: string
        },

        intervals: { [index: string]: string },

        exams: IExam[],

        defaultIp?: string,

        pageToRoles: Dictionary<Roles[]>
    }

    // eslint-disable no-use-before-define
    type RecursivePartial<T> = {
        [P in keyof T]?: RecursivePartial<T[P]>;
    };
    // eslint-enable no-use-before-define

    export type AppConfig = RecursivePartial<ExpertOfficeConfig>;

    const config: ExpertOfficeConfig;
    export default config;
}
