declare module 'yandex-logger/middleware/secure-cookie' {
    import { Middleware } from 'yandex-logger';

    export interface SecureCookieOptions {

        /** Path to find the cookie string in a log record ("req.headers.cookie" by default) */
        field?: string

        /** Cookies to obfuscate (e.g. "secret-key", "yandex_login") */
        cookies?: string[],

        /**
         * Obfuscator function
         *
         * @example
         * value.slice(0, Math.floor(value.length / 2)) +
         * 'X'.repeat(len - Math.floor(value.length / 2));
         */
        secureValue?: (value: string) => string
    }

    /**
     * Obfuscates cookies
     *
     * Source code:
     * https://github.yandex-team.ru/toolbox/yandex-logger/blob/master/middleware/secure-cookie.js
     */
    export default function(config?: SecureCookieOptions): Middleware;
}
