declare module 'yandex-logger/middleware/secure-field' {
    import { Middleware } from 'yandex-logger';

    export interface SecureFieldOptions {

        /** Fields to obfuscate */
        fields?: string[],

        /**
         * Obfuscator function
         *
         * @example
         * value.slice(0, Math.floor(value.length / 2)) +
         * 'X'.repeat(len - Math.floor(value.length / 2));
         */
        secureValue?: (value: string) => string
    }

    /**
     * Obfuscates log record fields
     *
     * Source code:
     * https://github.yandex-team.ru/toolbox/yandex-logger/blob/master/middleware/secure-field.js
     */
    export default function(config?: SecureFieldOptions): Middleware;
}
