declare module 'yandex-logger/middleware/secure-passport-cookie' {
    import { Middleware } from 'yandex-logger';

    export interface SecurePassportCookieOptions {

        /** Path to find the cookie string in a log record ("req.headers.cookie" by default) */
        field?: string

        /**
         * Passport cookies to obfuscate, by default:
         * "Session_id", "Secure_session_id", "sessionid2", "Eda_id", "edaid2"
         */
        cookies?: string[],
    }

    /**
     * Obfuscates passport cookies
     *
     * Source code:
     * https://nda.ya.ru/3URXN2
     */
    export default function(config?: SecurePassportCookieOptions): Middleware;
}
