declare module 'yandex-logger/middleware/secure-tvm-headers' {
    import { Middleware } from 'yandex-logger';

    export interface SecureTVMOptions {

        /** Path to find the headers string in a log record ("req.headers" by default) */
        field?: string[],
    }

    /**
     * Obfuscates the following TVM headers:
     * "x-ya-user-ticket", "x-ya-service-ticket" and "ticket"
     *
     * Source code:
     * https://nda.ya.ru/3URXMq
     */
    export default function(config: SecureTVMOptions): Middleware;
}
