declare module 'yandex-logger/streams/line' {
    import { ResolversMap } from 'yandex-logger';

    export interface LineStreamOptions {

        /**
         * Message template with placeholders.
         * Each placeholder represents a log record field.
         *
         * For example:
         * {{date}} {{logLevel}} {{msg}} {{err.stack}}
         */
        template?: string

        /**
         * Message placeholders resolvers
         *
         * @example
         * {
         *   date: record => record.date.toISOString()
         * }
         */
        resolvers?: ResolversMap

        /** Any writable stream (process.stdout by default) */
        stream?: NodeJS.WritableStream
    }

    /**
     * Formatted line stream
     *
     * Source code:
     * https://github.yandex-team.ru/toolbox/yandex-logger/blob/master/streams/line.js
     */
    export default function(config?: LineStreamOptions): NodeJS.WritableStream;
}
