import React, { Component } from 'react';
import { hydrate } from 'react-dom';
import { hot } from 'react-hot-loader';

import { Provider } from 'react-redux';
import { BrowserRouter } from 'react-router-dom';

import ReduxToastr from 'react-redux-toastr';

import configureStore, { ApplicationState } from '../store';

import App from '../components/app';

import './main.css';
import 'react-redux-toastr/lib/css/react-redux-toastr.min.css';

import { BundleProps, BundleData } from './types';

class Bundle extends Component<BundleProps> {
    store = configureStore(this.props.state);

    render() {
        const { data } = this.props;

        return (
            <Provider store={this.store}>
                <div>
                    <ReduxToastr
                        timeOut={60000} // 1 min
                        newestOnTop={false}
                        preventDuplicates
                        position="bottom-right"
                        transitionIn="fadeIn"
                        transitionOut="fadeOut"
                        closeOnToastrClick
                        />
                    <App data={data} />
                </div>
            </Provider>
        );
    }
}

export const DesktopBundle = hot(module)(Bundle);

export default (data: BundleData, state: ApplicationState) => {
    hydrate(
        <BrowserRouter>
            <DesktopBundle data={data} state={state} />
        </BrowserRouter>,
        document.getElementById('mount')
    );
};
