interface IAPIError {
    url: string,
    status: number,
    statusText: string,
    data: any
}

export class BaseError extends Error {
    public readonly code: string;

    public constructor(code: string) {
        super();
        this.code = code;

        Object.setPrototypeOf(this, new.target.prototype);
    }
}

export class APIError extends BaseError implements IAPIError {
    public readonly url: string;
    public readonly status: number;
    public readonly statusText: string;
    public readonly data: any;

    public constructor(code: string, error: IAPIError) {
        super(code);
        this.url = error.url;
        this.status = error.status;
        this.statusText = error.statusText;
        this.data = error.data;
    }
}
