import { APIError } from './errors/apiError';

interface IFetchOptions extends Partial<RequestInit> {}

export default async function <T> (path: string, options: IFetchOptions = {}): Promise<T> {
    const { headers = {}, ...restOptions } = options;

    const response = await fetch(path, {
        headers: {
            ...headers,
            Accept: 'application/json'
        },
        ...restOptions
    });

    if (!response.ok) {
        await handleErrorResponse(response);
    }

    return await handleSuccessResponse(response);
}

async function handleSuccessResponse(response: Response) {
    if (response.status === 204 || response.status === 201) {
        return;
    }

    return await response.json();
}

async function handleErrorResponse(response: Response) {
    const { url, status, statusText } = response;

    let data;
    let code;

    try {
        data = await response.json();
    } finally {
        code = (data && data.code) || `${status}_error`;
    }

    throw new APIError(code, { url, status, statusText, data });
}
