import URL from 'url-parse';
import qs from 'qs';

import { ISelectActiveAction } from 'client/store/tabs/types';

export function parseUrl(path: string) {
    return new URL(path, {}, parseQuery);
}

function parseQuery(query: string) {
    return qs.parse(query.slice(1));
}

export function stringifyUrl(url: URL) {
    const stringified = url.toString(stringifyQuery);

    return stringified.replace(url.origin, '');
}

function stringifyQuery(query: object) {
    return qs.stringify(query, { indices: false });
}

export function updateTabUrl(action: ISelectActiveAction) {
    const { history, name } = action.payload;

    if (!history) {
        return;
    }

    const url = parseUrl(window.location.href);

    url.query.tab = name;

    history.push(stringifyUrl(url));
}
